	% Example 12.21
	clear all
	close all
	clc
	
	wsT = 0.556*pi; Amin = 60; N = 11;
	[G, Z, P, wcT, wsT, Amax, Amin] = CA_POLES_HB_Z(wsT, Amin, N);
	% Compute the adaptor coefficients 	
	[Godd, Podd, Geven, Peven] = SORT_LATTICE_POLES_HB_Z(P)
	[alfa_odd, alfa_even] = CASCADE_RICHARDS_SECTIONS(Podd, Peven);
	d2 = -alfa_even(1:2:end) % Negate the nonzero coefficients
	d1 = -alfa_odd(2:2:end)	
	wT = linspace(-pi, pi, 1000);
	ei2wT = exp(j*2*wT);
	S1 = 1;	% Compute H(-z^2) for the odd and even branch
	for k=1:length(d1);
		S1 = S1.*(1 - d1(k)*ei2wT)./(ei2wT - d1(k));
	end
	S2 = -1;	
	for k=1:length(d2);
		S2 = -S2.*(1 - d2(k)*ei2wT)./(ei2wT - d2(k));
	end
	S_Hilbert = 0.5*(S2 - j*S1.*exp(-j*wT)); 	% Eq. 11.44 or 11.46
	Mag = H_2_MAG(S_Hilbert);
	subplot('position', [0.09 0.4 0.88 0.5]);
	PLOT_MAG_Z_Hilbert(wT,Mag, 90, 'H')
	

